#pragma rtGlobals=1		// Use modern global access method.
#pragma ModuleName = SNSLR
menu "Plot&fit"
	Submenu "Reflectivity Tools"
		"Scaled Regenerator", SNS_LR_Regenerator()
		"Change Scaled Names",   FixORNL_LR_Scaled_names()
		"-"
		"Load Biologic Potentiostat", BioLogicImport()
		"BiologicPlotting",  BiologicPlotting()		
	"-"
	end
end





Function FixORNL_LR_Scaled_names()//for old LR data may have to change ewave to kwave before using this tool
	string Samplefolder
	Prompt SampleFolder, "Select  data folder for sample", popup, FindQRSfolders()
	doprompt "Plot Input Panel", SampleFolder	
	SetDataFolder SampleFolder			
	FixNames_ORNL_LR()
end

function FixNames_ORNL_LR()//uses folder name as basename.  replaces basename with new name
	string name="",fullfoldername,rwavename,foldername, kwavename, wwavename,swavename
	foldername=getdatafolder(0)
	name=cleanupName(ReplaceString("'", foldername, ""),1)
	name =CleanupName(Getnamechanges(name), 0 )
	IF (stringmatch(name, ""))
		Return 0
	endif
	string Ra,Qa,Sa,Ea,Wa,oldRa,oldQa,oldSa,oldEa,oldWa
	if (!stringmatch(name, foldername ))
		fullfoldername="::"+foldername
		RenameDataFolder $fullfoldername,$name
	endif
		name=name[1,30]

		Ra="r"+name
		Qa="q"+name
		Sa="s"+name
		Ea="k"+name
		Wa="w"+name
		foldername =ReplaceString("'", foldername, "")//takes out ' for liberal names
		foldername=foldername[1,30]//problem if no dummy letter in folder name
		oldRa="r"+foldername
		oldQa="q"+foldername
		oldSa="s"+foldername
		oldEa="k"+foldername
		oldWa="w"+foldername
		rename $oldSa,$Sa
		rename $oldRa,$Ra	
		
		wave/z w=$oldEa
			if (waveexists(w))
				rename $oldEa,$Ea
			endif
	
		wave/z w=$oldQa//qwaves don't exist in subfolders.  q is renamed an ewave to avoid picking up in wave selction tools.
			if (waveexists(w))
				rename $oldQa,$Qa
			endif
			
		wave/z w=$oldWa
			if (waveexists(w))
				rename $oldWa,$Wa
			endif	
	SVAR basename=basename
	basename=name
	NVAR subsets
	
	setdatafolder :PartialWavesFolder//Partialwavesfolder
	variable Pass=0
		Do
		string passstr =num2str(pass)
		rwavename=StringFromList(pass,WaveList("r*", ";",""),";")
		kwavename=StringFromList(pass,WaveList("k*", ";",""),";")
		swavename=StringFromList(pass,WaveList("s*", ";",""),";")
		wwavename=StringFromList(pass,WaveList("w*", ";",""),";")
		wave rwave=$rwavename
		string newRwavename="r"+basename+num2str(pass)
		string newkwavename="k"+basename+num2str(pass)
		string newSwavename="s"+basename+num2str(pass)
		string newWwavename="w"+basename+num2str(pass)	
		if(!waveexists (rwave))
			DoAlert 0,"No partial waves."
			abort
		endif
				rename $rwavename,$newRwavename
				rename $kwavename,$newkwavename
				rename $swavename,$newSwavename
				rename $wwavename,$newWwavename
				
		Pass+=1
	while (pass<subsets)
	setdatafolder ::OriginalWavesFolder//Original waves folder
	Pass=0
		Do
		passstr =num2str(pass)
		rwavename=StringFromList(pass,WaveList("r*", ";",""),";")
		kwavename=StringFromList(pass,WaveList("k*", ";",""),";")
		swavename=StringFromList(pass,WaveList("s*", ";",""),";")
		wwavename=StringFromList(pass,WaveList("w*", ";",""),";")
		wave rwave=$rwavename
		newRwavename="r"+basename+num2str(pass)
		newkwavename="k"+basename+num2str(pass)
		newSwavename="s"+basename+num2str(pass)
		newWwavename="w"+basename+num2str(pass)	
		if(!waveexists (rwave))
			DoAlert 0,"No partial waves."
			abort
		endif
				rename $rwavename,$newRwavename
				rename $kwavename,$newkwavename
				rename $swavename,$newSwavename
				rename $wwavename,$newWwavename		
		Pass+=1
	while (pass<subsets	)
end

Function BioLogicImport()//Loads .mpt files form Biologic potentiostat
	setdatafolder root:
	String LineOfNote,name,fullpath
	variable refno, str
	string theNote
	Open/R/T=".mpt"/m=".mpt file" refno //as filename//User picks a file
	TheNote=s_filename+"\r"
		do//get the header information
			FReadLine refNo, LineOfNote
			abortonRTE
			TheNote+=LineOfNote
			if (stringmatch(LineofNote, "*File : *" ))
				str=strlen(lineofNote)-6
				name=lineofNote[8,str]
				Prompt name,"Check new name"
				doprompt "Enter New Name",name
					If (V_flag)
						abort
					endif
				name=CleanupName(name,0)	
				name=name[0,31]				
			endif
			if (stringmatch(LineofNote, "*error*" ))
				break
			endif		
		while(1)		
	NewDataFolder/O/S $name
	killwaves/A/Z
	String/g Header=TheNote
	LoadWave/G/W/N/Q s_filename
end

Function BiologicPlotting()
	DoWindow Biologic_Graph
	if(V_Flag)
		DoWindow/K  Biologic_Graph
	endif
	make/o/N=2 xavedata,yavedata
	xavedata={ .02, .15}
	yavedata={ 1, .01}
	Display/K=1/N=Biologic_Graph/W=(0,0,500,500) Yavedata vs Xavedata
	ControlBar /T 55
	setAxis bottom .02, .1
	SetAxis/A left
	Label left "Potential (V)";DelayUpdate
	Label bottom "Time"
	removefromgraph yavedata
	killwaves/z yavedata,xavedata

#if((exists("IR2C_AddDataControls")==6))	//Must have Irena Code from Jan Ilavsky (ANL) to use the dropdown folder selecdtion tool	
		String PckgDataFolder="BiologicTool"//"SNSLRTool"
		String PanelWindowName="Biologic_Graph"
		String AllowedIrenaTypes=""//"DSM_Int;SMR_Int;"
		String AllowedResultsTypes=""//"SLDPROFILE;"//"SizesNumberDistribution;SizesVolumeDistribution;"
		String AllowedUserTypes="I_mA;Ewe_V;"	
		String UserNameString= ""
		String XUserTypeLookup="I_mA:time_s;Ewe_V:time_s;"	
		String EUserTypeLookup=""//"s*;"
		variable RequireErrorWaves=0
		variable  AllowModelData=0
		IR2C_AddDataControls(PckgDataFolder,PanelWindowName,AllowedIrenaTypes, AllowedResultsTypes, AllowedUserTypes, UserNameString, XUserTypeLookup,EUserTypeLookup, RequireErrorWaves,AllowModelData)
		PopupMenu SelectDataFolder pos={2,1}
		PopupMenu QvecDataName disable=0, Pos= {330,20}
		PopupMenu IntensityDataName disable=0, Pos ={330, 0}
		PopupMenu ErrorDataName disable=1,Pos ={330, 40}
		CheckBox UseQRSData ,value=0,pos={0, 0},value=0, disable=1
		SetVariable FolderMatchStr, disable =1
		SetVariable WaveMatchStr, disable=1
		Checkbox UseUserDefinedData, disable=1
		NVAR UseUserDefinedData = root:Packages:BiologicTool:UseUserDefinedData
		UseUserDefinedData=1
#else
		SVAR folder=root:Packages:BiologicTool:DataFolderName
		folder=""
		DoAlert 0,"Irena  package not loaded   http://usaxs.xor.aps.anl.gov/staff/ilavsky/irena.html"
		Dowindow /K Biologic_Graph
		abort
#endif
	
	//Button Concat,pos={100,20},size={80,16},win=Biologic_Graph ,font="Times New Roman",fSize=10,proc= SNSLR_InputPanelButtonProc,title="Concatenate"	
	Button RemoveBio,pos={200,20},size={80,16},win=Biologic_Graph  ,font="Times New Roman",fSize=10,proc= Biologic_InputPanelButtonProc,title="Clear"
	Button PlotBio,pos={0,20},size={80,16},win=Biologic_Graph,font="Times New Roman",fSize=10,proc= Biologic_InputPanelButtonProc,title="Plot"	
	//Button Deletepoint,pos={0,38},size={100,16},win=Biologic_Graph,font="Times New Roman",fSize=10,proc= Biologic_InputPanelButtonProc,title="delete point"	
	//Button restorepartialwave,pos={400,38},size={100,16},win=Biologic_Graph  ,font="Times New Roman",fSize=10,proc= SNSLR_InputPanelButtonProc,title="Restore Partial Wave"
end

function Biologic_InputPanelButtonProc(ctrlName) : ButtonControl
	string ctrlName

	SVAR DF=root:Packages:BiologicTool:DataFolderName
	SVAR qwavename=root:Packages:BiologicTool:qwavename
	SVAR rwavename=root:Packages:BiologicTool:IntensityWaveName
	
IF(cmpstr(ctrlName,"RemoveBio")==0)
		string tracename, tracelist=TraceNameList("Biologic_Graph", ";", 1 )
		variable i, imax=ItemsInList(tracelist  ,";")
		for (i=imax;i>=1;i-=1)
			tracename=StringFromList(i, tracelist,";")		
			RemoveFromGraph $tracename	;AbortOnRTE
		endfor
	endif	
	
	if(cmpstr(ctrlName,"Deletepoint")==0)
		DF=getdatafolder(1)		
		
		Doalert 0, "disabled"
		setdatafolder getwavesDataFolder(csrwaveref(A),1) 		
		setdatafolder DF
	endif
	
	if(cmpstr(ctrlName,"PlotBio")==0)	
		SVAR DF=root:Packages:BiologicTool:DataFolderName
	if ( exists("root:Packages:BiologicTool:DataFolderName"))//may not esxist if Irena is not activated
		IF(DataFolderExists(DF))
			setdatafolder DF
			appendtograph $rwavename vs $qwavename
		else
			DoAlert 0,"Pick the folder, dummy"
			abort
		endif
	endif
endif
	
end


Function SNS_LR_Regenerator()
	DoWindow SNS_LR_Graph
	if(V_Flag)
		DoWindow/K SNS_LR_Graph
	endif
	make/o/N=2 xavedata,yavedata
	xavedata={ .02, .15}
	yavedata={ 1, .01}
	Display/K=1/N=SNS_LR_Graph/W=(0,0,500,500) Yavedata vs Xavedata
	ControlBar /T 55
	setAxis bottom .02, .1
	SetAxis/A left
	Label left "Reflectivity";DelayUpdate
	Label bottom "q(A-1)"
	removefromgraph yavedata
	killwaves/z yavedata,xavedata
	newdatafolder/o root:Packages:SNSLRTool
	variable/g root:Packages:SNSLRTool:shift
	variable/g root:Packages:SNSLRTool:qshift
	variable/g root:Packages:SNSLRTool:qshiftdelta
	NVAR qshift=root:Packages:SNSLRTool:qshift,shift=root:Packages:SNSLRTool:shift
	NVAR qshiftdelta=root:Packages:SNSLRTool:qshiftdelta
	qshiftdelta=.005
	qshift=1;shift=1
#if((exists("IR2C_AddDataControls")==6))	//Must have Irena Code from Jan Ilavsky (ANL) to use the dropdown folder selecdtion tool	
		String PckgDataFolder="SNSLRTool"
		String PanelWindowName="SNS_LR_Graph"
		String AllowedIrenaTypes=""//"DSM_Int;SMR_Int;"
		String AllowedResultsTypes=""//"SLDPROFILE;"//"SizesNumberDistribution;SizesVolumeDistribution;"
		String AllowedUserTypes=""//"SLDPROFILE*;"//"*_par;" or "r*;"	
		String UserNameString= ""
		String XUserTypeLookup="r*:q*:s*;"	//"r*:q*;"	
		String EUserTypeLookup="s*;"//"s*;"
		variable RequireErrorWaves=1
		variable  AllowModelData=0
		//string cmd="IR2C_AddDataControls(\""+PckgDataFolder+"\",\""+PanelWindowName+"\",\""+AllowedIrenaTypes+"\",\""+ AllowedResultsTypes+"\",\""+ AllowedUserTypes+"\",\""+UserNameString+"\",\""+ XUserTypeLookup+"\",\""+EUserTypeLookup+"\","+num2str(RequireErrorWaves)+","+num2str(AllowModelData)+")"
		IR2C_AddDataControls(PckgDataFolder,PanelWindowName,AllowedIrenaTypes, AllowedResultsTypes, AllowedUserTypes, UserNameString, XUserTypeLookup,EUserTypeLookup, RequireErrorWaves,AllowModelData)
		PopupMenu SelectDataFolder pos={2,1}
		PopupMenu QvecDataName disable=1
		PopupMenu IntensityDataName disable=1
		PopupMenu ErrorDataName disable=1
		CheckBox UseQRSData ,value=1,pos={0, 0},value=0  
		CheckBox UseQRSData disable=1	
#else
		SVAR folder=root:Packages:SNSLRTool:DataFolderName
		folder=""
		DoAlert 0,"Irena  package not loaded   http://usaxs.xor.aps.anl.gov/staff/ilavsky/irena.html"
		Dowindow /K SNS_LR_Graph
		abort
#endif
			SVAR FolderMatchStr=root:Packages:IrenaControlProcs:SNS_LR_Graph:FolderMatchStr
		FolderMatchStr=""
		SetVariable WaveMatchStr pos={295,20}
		SetVariable FolderMatchStr pos={293,3}
			
	Button Concat,pos={100,20},size={80,16},win=SNS_LR_Graph ,font="Times New Roman",fSize=10,proc= SNSLR_InputPanelButtonProc,title="Concatenate"	
	Button RemoveReflTrace,pos={200,20},size={80,16},win=SNS_LR_Graph ,font="Times New Roman",fSize=10,proc= SNSLR_InputPanelButtonProc,title="Clear"
	Button PlotSNSLR,pos={0,20},size={80,16},win=SNS_LR_Graph ,font="Times New Roman",fSize=10,proc= SNSLR_InputPanelButtonProc,title="PLOT"	
	Button Deletepoint,pos={0,38},size={100,16},win=SNS_LR_Graph ,font="Times New Roman",fSize=10,proc= SNSLR_InputPanelButtonProc,title="delete point"
		Button fullQ4R,pos={420,00},size={80,16},win=SNS_LR_Graph ,font="Times New Roman",fSize=10,proc= SNSLR_InputPanelButtonProc,title="Full Q4R Plot"
		Button Q4R,pos={420,20},size={80,16},win=SNS_LR_Graph ,font="Times New Roman",fSize=10,proc= SNSLR_InputPanelButtonProc,title="Q4R Plot"
	SetVariable shift, pos={120,38}, size={80,30},title="Shift", proc=SNSLR_SetVariableControl
	SetVariable shift, limits={-inf,Inf,0.01},value= root:Packages:SNSLRTool:shift
	SetVariable qshiftdelta, pos={280,38}, size={120,30},title="qShiftdelta", proc=SNSLR_SetVariableControl	
	SetVariable qshiftdelta, limits={0,1,.001},value= root:Packages:SNSLRTool:qshiftdelta	
	SetVariable qshift, pos={200,38}, size={80,30},title="qShift", proc=SNSLR_SetVariableControl
	SetVariable qshift, limits={-inf,Inf,.001},value= root:Packages:SNSLRTool:qshift	
	
	Button restorepartialwave,pos={400,38},size={100,16},win=SNS_LR_Graph ,font="Times New Roman",fSize=10,proc= SNSLR_InputPanelButtonProc,title="Restore Partial Wave"
end

Function SNS_LR_RegeneratorPLOT()
	string rwavename,qwavename,swavename,wwavename
		SVAR DF=root:Packages:SNSLRTool:DataFolderName

	if ( exists("root:Packages:SNSLRTool:DataFolderName"))//may not esxist if Irena is not activated
		IF(DataFolderExists(DF ))
			setdatafolder DF
		else
			DoAlert 0,"Pick the data, dummy"
			abort
		endif
	endif
	string name1=GetDataFolder(0)
	name1=name1[1,100]
	
	If (exists("basename")!=2)//see if pointing to a datafolder
		doalert 0, "Invalid Datafolder. Use Data Browser.\r\ror Select Folder (Irena Users Only)"
		abort
	endif
	SVAR basename
	NVAR subsets
	variable Pass=0
	basename=name1
	
	string passstr	,tracename
	setdatafolder :PartialWavesFolder
	Do
		passstr =num2str(pass)
	//	qwavename="e"+basename+passstr;swavename="s"+basename+passstr;Wwavename="W"+basename+passstr
		//rwavename=":PartialWavesFolder:r"+basename+passstr;
		rwavename=StringFromList(pass,WaveList("r*", ";",""),";")
		qwavename=StringFromList(pass,WaveList("k*", ";",""),";")
		swavename=StringFromList(pass,WaveList("s*", ";",""),";")
		wwavename=StringFromList(pass,WaveList("w*", ";",""),";")
		
		wave qwave=$qwavename, rwave=$rwavename,swave=$swavename
		if(!waveexists (rwave))
			DoAlert 0,"No partial waves.  Pick again"
			abort
		endif
		tracename=StringFromList(0, TraceNameList("SNS_LR_Graph", ";", 1 ),";")
		appendtograph  rwave vs qwave
		tracename="r"+basename+passstr
		ErrorBars $rwavename, Y wave=(swave,swave)

		Pass+=1
	while (pass<subsets	)
	Label left "Reflectivity";DelayUpdate
	Label bottom "q(A-1)"
	ChangetoLineandPoints(3,1);ModifyGraph grid=2,log=1,mirror=1,axThick=2 ,msize=2
	 showinfo	
	tracename=StringFromList(0, TraceNameList("SNS_LR_Graph", ";", 1 ),";")
	Cursor/P A, $tracename,0
	DoWindow/T SNS_LR_Graph,basename	
	setdatafolder DF
end

Function  Rq4plot()//************************************
	string rwavename,qwavename,swavename,wwavename
		SVAR DF=root:Packages:SNSLRTool:DataFolderName
	if ( exists("root:Packages:SNSLRTool:DataFolderName"))//may not esxist if Irena is not activated
		IF(DataFolderExists(DF ))
			setdatafolder DF
		else
			DoAlert 0,"Pick the Folder first"
			abort
		endif
	endif
	ClearGraph_LR()
	string name1=GetDataFolder(0)
	name1=name1[1,100]
	
	If (exists("basename")!=2)//see if pointing to a datafolder
		doalert 0, "Invalid Datafolder. Use Data Browser.\r\ror Select Folder (Irena Users Only)"
		abort
	endif
	SVAR basename
	NVAR subsets
	variable Pass=0
	basename=name1
	
	string passstr	,tracename,newRwavename,newSwavename
	setdatafolder :PartialWavesFolder
	Do
		passstr =num2str(pass)
		rwavename=StringFromList(pass,WaveList("r*", ";",""),";")
		qwavename=StringFromList(pass,WaveList("k*", ";",""),";")
		swavename=StringFromList(pass,WaveList("s*", ";",""),";")
		wwavename=StringFromList(pass,WaveList("w*", ";",""),";")
		
		wave qwave=$qwavename, rwave=$rwavename,swave=$swavename
		if(!waveexists (rwave))
			DoAlert 0,"No partial waves.  Pick again"
			abort
		endif
		newRwavename=rwavename[0,6]+num2str(pass)
		newSwavename=swavename[0,6]+num2str(pass)
		Duplicate/o $rwavename, $newRwavename
		Duplicate/o $swavename, $newSwavename
		wave rwave=$NewRwavename
		wave swave=$NewSwavename
		rwave*=qwave^4
		swave*=qwave^4
		appendtograph  rwave vs qwave
		ErrorBars $newRwavename, Y wave=(swave,swave)
		Pass+=1
	while (pass<subsets	)
	Label left "Reflectivity";DelayUpdate
	Label bottom "q(A-1)"
	ChangetoLineandPoints(3,1);ModifyGraph grid=2,log=1,mirror=1,axThick=2 ,msize=2
	 showinfo	
	tracename=StringFromList(0, TraceNameList("SNS_LR_Graph", ";", 1 ),";")
	Cursor/P A, $tracename,0
	DoWindow/T SNS_LR_Graph,basename	
	//setdatafolder DF
	ModifyGraph log(bottom)=0
end

function LANL_AX_load_Scaled()//loads .oux files with multiple runs LANL Asterix
	variable qloadall=2,linelimit=500	
	setdatafolder root:
	if (!DataFolderExists( "root:Packages:SNSLRTool"))
		if (!DataFolderExists( "root:Packages"))
			newdatafolder root:Packages
		endif
		newdatafolder root:Packages:SNSLRTool
	endif
	variable/g root:Packages:SNSLRTool:shift=1,root:Packages:SNSLRTool:qshift=1, root:Packages:SNSLRTool:pass=0
	variable Counter=0,length, refno,pass=5
	String theNote,name,samplename,path,fullpath
		
		Prompt Pass,"Number of Partial Waves"
			doprompt "Enter Number of partial waves",Pass
				If (V_flag)
					abort
				endif
			
	Open/R/F="*ou*"/m=".oux files only" refno //as filename//User picks a file
	fullpath=s_filename
	counter=0
	TheNote=fullpath+"\r"
	string Filename=ParseFilePath(0, fullpath, ":", 1, 0)
		
		samplename=CleanupName(Filename,0)	
		name="A"+"_"+samplename[1,inf]
		Prompt name,"Check new name"
			doprompt "Enter New Name",name
				If (V_flag)
					abort
				endif
				variable N=Strlen(Name)
				Name=name[0,(N-1)]
		name=name[0,29]
		NewDataFolder/O/S $name
		name=name[1,100]
		String/g Header="\r"+TheNote
		Header= ReplaceString("\t", Header, "");Header= ReplaceString("*", Header, "")
		

	counter=0
	
	string rwavename,qwavename,swavename,kwavename,Wwavename,destination
	dowindow/K Asterix_Graph 
	KillDataFolder/z PartialWavesFolder
	Newdatafolder PartialWavesFolder
	KillDataFolder/z OriginalWavesFolder
	Newdatafolder OriginalWavesFolder
	String PartialPath=ParseFilePath(1, fullpath, ":", 1, 0)
	
	string partialwavepath=partialpath+filename
	 N=strlen(partialwavepath)
	Do
		partialwavepath=partialwavepath[0,N-2]+num2str(counter)
		Loadwave/q /n=w/g/k=1 partialwavepath
		wave w0,w1,w2,W3
		variable i=0
		for (i=numpnts(w1);i>=0;i-=1)//zap zeros and negatives
			if ((w1[i] <= 0))
				Deletepoints i, 1, w0,w1,w2,w3
			endif	
			if(pass==5)
				
			endif
			//W2=sqrt(w2)//variance, not std dev
			//w3=sqrt(w3)
		endfor	
			qwavename="q"+name+num2str(counter)
			rwavename="r"+name+num2str(counter)
			swavename="s"+name+num2str(counter)
			kwavename="k"+name+num2str(counter)
			Wwavename="W"+name+num2str(counter)
			
			duplicate/o w0,$qwavename;duplicate/o w1,$rwavename;duplicate/o w2,$swavename
			duplicate/o w3,$Wwavename
			wave qwave=$qwavename, rwave=$rwavename,swave=$swavename,Wwave=$Wwavename
			swave=sqrt(swave)
			wwave=sqrt(wwave)
			Note/K qwave, "Qshift=1;"
			Note/K rwave, "shift=1;"

			Movewave qwave, :PartialWavesFolder:
			Movewave rwave, :PartialWavesFolder:
			Movewave swave, :PartialWavesFolder:
			Movewave wwave, :PartialwavesFolder:
			rename qwave,$kwavename//change name of s wave to avoid pickup by folder selector tool

			destination=":OriginalWavesFolder:"+kwavename
			Duplicate/o qwave ,$destination
			destination=":OriginalWavesFolder:"+rwavename
			Duplicate/o rwave ,$destination
			destination=":OriginalWavesFolder:"+swavename
			Duplicate/o swave ,$destination
			destination=":OriginalWavesFolder:"+Wwavename
			Duplicate/o Wwave ,$destination				
			counter=counter+1	
		if (Counter==1)
			dowindow/K Asterix_Graph 
			display/k=1/N=Asterix_Graph /W=(10, 10, 500, 500 ) rwave vs qwave
			ErrorBars $rwavename, Y wave=(swave,swave)
		else
			appendtograph  rwave vs qwave
			ErrorBars $rwavename, Y wave=(swave,swave)
			endif
	While (counter<Pass)
	
	string/g basename=name
	ConcatQRSwaves()//puts concatinated wave back in top folder
	DeletePointsButton()
	Button Concat,pos={0,0},size={80,16} ,font="Times New Roman",fSize=10,proc= SNSLR_InputPanelButtonProc,title="Concatenate"
	Button Q4R,pos={100,00},size={80,16} ,font="Times New Roman",fSize=10,proc= SNSLR_InputPanelButtonProc,title="Q4R Plot"
	Button Deletepoint,pos={0,15},size={100,16} ,font="Times New Roman",fSize=10,proc= SNSLR_InputPanelButtonProc,title="delete point"
	SetVariable shift, pos={120,15}, size={80,30},title="rShift", proc=SNSLR_SetVariableControl
	SetVariable shift, limits={-inf,Inf,0.01},value= root:Packages:SNSLRTool:shift	
	SetVariable qshift, pos={300,15}, size={80,30},title="qShift", proc=SNSLR_SetVariableControl
	SetVariable qshift, limits={-inf,Inf,0.01},value= root:Packages:SNSLRTool:qshift		
	ChangetoLineandPoints(3,1);ModifyGraph grid=2,log=1,mirror=1,axThick=2 ,msize=2
	 showinfo	
	variable/g subsets=pass
	
	killwaves/z w0,w1,w2,w3,breaks,breaks1, breaks
	TextBox/C/N=text0/A=RT name
	DoWindow/T Asterix_Graph ,name
	ControlBar /T 32
	string tracename=StringFromList(0, TraceNameList("SNS_LR_Graph", ";", 1 ),";")
	Cursor/P A, $tracename,0
end


function SNS_LR_load_Scaled()//loads .txt files with multiple runs ORNL SNS
	variable qloadall=2,linelimit=500	
	setdatafolder root:
	if (!DataFolderExists( "root:Packages:SNSLRTool"))
		if (!DataFolderExists( "root:Packages"))
			newdatafolder root:Packages
		endif
		newdatafolder root:Packages:SNSLRTool
	endif
	variable/g root:Packages:SNSLRTool:shift=1,root:Packages:SNSLRTool:qshift=1, root:Packages:SNSLRTool:pass=0
	variable Counter=0,length, refno,samplenamelength,rows,start,stop,step,pass=0,counter1=0
	String LineOfNote,samplerun, theNote,name,samplename,path,fullpath,rwavenamestring,qwavenamestring,swavenamestring, wwavenamestring
	Open/R/T=".txt"/m="text file only" refno //as filename//User picks a file
	fullpath=s_filename
	variable Totaltests=0, qspace=0	
	counter=0
	TheNote=fullpath+"\r"
		do//get the header information
			FReadLine refNo, LineOfNote;abortonRTE
			TheNote+=LineOfNote					
				if (stringmatch(LineofNote, "#C data Run Number:*" ))
					samplenamelength =strlen(lineofnote)
					samplerun=lineofnote[20,24]//,samplenamelength-2]	changed to handle multiple runs			
				endif			
				if (stringmatch(LineofNote, "#C data Title:*" ))
					samplenamelength =strlen(lineofnote)
					samplename=lineofnote[15,samplenamelength-10]
				endif		
			Counter+=1
			if (stringmatch(LineofNote, "#C SCL Version*" ))
				break
			endif
		while(1)

		samplename=CleanupName(samplename,0)	
		name="R"+samplerun+"_"+samplename
		Prompt name,"Check new name"
			doprompt "Enter New Name",name
				If (V_flag)
					abort
				endif
		name=name[0,29]
		NewDataFolder/O/S $name
		name=name[1,100]
		String/g Header="\r"+TheNote
		Header= ReplaceString("\t", Header, "");Header= ReplaceString("*", Header, "")
		Make/o /N=10 breaks
		
		do// find the number of series of incident angles
			FReadLine refNo, LineOfNote	;counter=counter+1			
			if (stringmatch(LineofNote, "#Incident angle:*" ))//find series in CM files
				Breaks[counter1]=counter
				counter1+=1
			endif
			if (stringmatch(LineofNote, "#L scalar*" ))//find series in  individual .txt files
				Breaks[counter1]=counter
				counter1+=1
			endif
			if (stringmatch(LineofNote, "" ))//blank line at end of file
				Breaks[counter1]=counter	
				break
			endif			
		while (1)	
	duplicate/o/R=[0,counter1] breaks,breaks1

	counter=0;pass=0
	variable p=0
	string rwavename,qwavename,swavename,ewavename,Wwavename,destination
	dowindow/K SNS_LR_Graph  
	KillDataFolder/z PartialWavesFolder
	Newdatafolder PartialWavesFolder
	KillDataFolder/z OriginalWavesFolder
	Newdatafolder OriginalWavesFolder
	Do
		Loadwave/q /n=w/g/k=1/L={0,Breaks1[counter],breaks1[counter+1],0,4} fullpath
		wave w0,w1,w2,W3
		variable i=0
		for (i=numpnts(w1);i>=0;i-=1)//zap zeros and negatives
			if ((w1[i] <= 0))
				Deletepoints i, 1, w0,w1,w2,w3
			endif	
		endfor	
			qwavename="q"+name+num2str(pass)
			rwavename="r"+name+num2str(pass)
			swavename="s"+name+num2str(pass)
			ewavename="e"+name+num2str(pass)
			Wwavename="W"+name+num2str(pass)
			
			duplicate/o w0,$qwavename;duplicate/o w1,$rwavename;duplicate/o w2,$swavename
			duplicate/o w3,$Wwavename
			wave qwave=$qwavename, rwave=$rwavename,swave=$swavename,Wwave=$Wwavename
			
			Note/K qwave, "Qshift=1;"
			Note/K rwave, "shift=1;"

			Movewave qwave, :PartialWavesFolder:
			Movewave rwave, :PartialWavesFolder:
			Movewave swave, :PartialWavesFolder:
			Movewave wwave, :PartialwavesFolder:
			rename qwave,$ewavename//change name of s wave to avoid pickup by folder selector tool

			destination=":OriginalWavesFolder:"+ewavename
			Duplicate/o qwave ,$destination
			destination=":OriginalWavesFolder:"+rwavename
			Duplicate/o rwave ,$destination
			destination=":OriginalWavesFolder:"+swavename
			Duplicate/o swave ,$destination
			destination=":OriginalWavesFolder:"+Wwavename
			Duplicate/o Wwave ,$destination
						
			counter=counter+1
			pass=pass+1		
		if (pass==1)
			dowindow/K SNS_LR_Graph 
			display/k=1/N=SNS_LR_Graph/W=(10, 10, 500, 500 ) rwave vs qwave
			ErrorBars $rwavename, Y wave=(swave,swave)
		else
			appendtograph  rwave vs qwave
			ErrorBars $rwavename, Y wave=(swave,swave)
			endif
	While ( counter<numpnts (breaks1)-1)
	string/g basename=name
	ConcatQRSwaves()//puts concatinated wave back in top folder
	DeletePointsButton()
	Button Concat,pos={0,0},size={80,16},win=SNS_LR_Graph ,font="Times New Roman",fSize=10,proc= SNSLR_InputPanelButtonProc,title="Concatenate"
	Button Q4R,pos={100,00},size={80,16},win=SNS_LR_Graph ,font="Times New Roman",fSize=10,proc= SNSLR_InputPanelButtonProc,title="Q4R Plot"
	Button Deletepoint,pos={0,15},size={100,16},win=SNS_LR_Graph ,font="Times New Roman",fSize=10,proc= SNSLR_InputPanelButtonProc,title="delete point"
	SetVariable shift, pos={120,15}, size={80,30},title="rShift", proc=SNSLR_SetVariableControl
	SetVariable shift, limits={-inf,Inf,0.01},value= root:Packages:SNSLRTool:shift	
	SetVariable qshift, pos={300,15}, size={80,30},title="qShift", proc=SNSLR_SetVariableControl
	SetVariable qshift, limits={-inf,Inf,0.01},value= root:Packages:SNSLRTool:qshift		
	ChangetoLineandPoints(3,1);ModifyGraph grid=2,log=1,mirror=1,axThick=2 ,msize=2
	 showinfo	
	variable/g subsets=numpnts (breaks1)-1
	
	killwaves/z w0,w1,w2,w3,breaks,breaks1, breaks
	TextBox/C/N=text0/A=RT name
	DoWindow/T SNS_LR_Graph,name
	ControlBar /T 32
	string tracename=StringFromList(0, TraceNameList("SNS_LR_Graph", ";", 1 ),";")
	Cursor/P A, $tracename,0
end



function SNS_LR_load_Combined()//loads .txt files with multiple runs ORNL SNS
	variable qloadall=2,linelimit=500	
	setdatafolder root:
	if (!DataFolderExists( "root:Packages:SNSLRTool"))
		if (!DataFolderExists( "root:Packages"))
			newdatafolder root:Packages
		endif
		newdatafolder root:Packages:SNSLRTool
	endif
	variable/g root:Packages:SNSLRTool:shift=1,root:Packages:SNSLRTool:qshift=1, root:Packages:SNSLRTool:pass=0
	variable Counter=0,length, refno,samplenamelength,rows,start,stop,step,pass=0,counter1=0
	String LineOfNote,samplerun, theNote,name,samplename,path,fullpath,rwavenamestring,qwavenamestring,swavenamestring
	//string/g Root:Packages:P:gfilename
	//SVAR filename=Root:Packages:P:gfilename
		Open/R/T=".txt"/m="CE text file only" refno //as filename//User picks a file
		fullpath=s_filename
		variable Totaltests=0, qspace=0	
		counter=0
		TheNote=fullpath+"\r"
		do//get the header information
			FReadLine refNo, LineOfNote:abortonRTE
			TheNote+=LineOfNote
						
				if (stringmatch(LineofNote, "#C data Run Number:*" ))
					samplenamelength =strlen(lineofnote)
					samplerun=lineofnote[20,24]//,samplenamelength-2]	changed to handle multiple runs			
				endif			
				if (stringmatch(LineofNote, "#C data Title:*" ))
					samplenamelength =strlen(lineofnote)
					samplename=lineofnote[15,samplenamelength-10]
				endif		
				Counter+=1
			if (stringmatch(LineofNote, "#C SCL Version*" ))
				break
			endif
		while(1)

		samplename=CleanupName(samplename,0)	
		name="R"+samplerun+"_"+samplename
		Prompt name,"Check new name"
			doprompt "Enter New Name",name
				If (V_flag)
					abort
				endif
		name=name[0,29]
		NewDataFolder/O/S $name

		name=name[1,100]
		String/g Header=TheNote
		Header= ReplaceString("\t", Header, "");Header= ReplaceString("*", Header, "")
		Make/o /N=10 breaks
		
		do// find the number of series of incident angles
			FReadLine refNo, LineOfNote	;counter=counter+1			
			if (stringmatch(LineofNote, "#Incident angle:*" ))//find series in CM files
				Breaks[counter1]=counter
				counter1+=1
			endif
			if (stringmatch(LineofNote, "#L scalar*" ))//find series in  individual .txt files
				Breaks[counter1]=counter
				counter1+=1
			endif
			if (stringmatch(LineofNote, "" ))//blank line at end of file
				Breaks[counter1]=counter	
				break
			endif			
		while (1)	
	duplicate/o/R=[0,counter1] breaks,breaks1

	counter=0;pass=0
	variable p=0
	string rwavename,qwavename,swavename,wwavename,destination
	dowindow/K SNS_LR_Graph  

			Loadwave/q /n=w/g/k=1/L={0,0,0,0,4} fullpath
		wave w0,w1,w2,W3
		variable i=0
		for (i=numpnts(w1);i>=0;i-=1)//zap zeros and negatives
			if ((w1[i] <= 0))
				Deletepoints i, 1, w0,w1,w2
			endif	
		endfor	
			qwavename="q"+name//+num2str(pass)
			rwavename="r"+name//+num2str(pass)
			swavename="s"+name//+num2str(pass)
			wwavename="w"+name//+num2str(pass)
			
			duplicate/o w0,$qwavename;duplicate/o w1,$rwavename;duplicate/o w2,$swavename;duplicate/o w3,$wwavename
			wave qwave=$qwavename, rwave=$rwavename,swave=$swavename,wwave=$wwavename
			
			Note/K qwave, "Qshift=1;"
			Note/K rwave, "shift=1;"
				
	
			dowindow/K SNS_LR_Graph 
			display/k=1/N=SNS_LR_Graph/W=(10, 10, 500, 500 ) rwave vs qwave
			ErrorBars $rwavename, Y wave=(swave,swave)

	string/g basename=name
	//ConcatQRSwaves()//puts concatinated wave back in top folder
	DeletePointsButton()
	//Button Concat,pos={100,0},size={80,16},win=SNS_LR_Graph ,font="Times New Roman",fSize=10,proc= SNSLR_InputPanelButtonProc,title="Concatenate"
	Button Deletepoint,pos={0,15},size={100,16},win=SNS_LR_Graph ,font="Times New Roman",fSize=10,proc= SNSLR_InputPanelButtonProc,title="delete point"
	SetVariable shift, pos={120,15}, size={80,30},title="rShift", proc=SNSLR_SetVariableControl
	SetVariable shift, limits={-inf,Inf,0.01},value= root:Packages:SNSLRTool:shift	
	SetVariable qshift, pos={300,15}, size={80,30},title="qShift", proc=SNSLR_SetVariableControl
	SetVariable qshift, limits={-inf,Inf,0.01},value= root:Packages:SNSLRTool:qshift		
	ChangetoLineandPoints(3,1);ModifyGraph grid=2,log=1,mirror=1,axThick=2 ,msize=2
	 showinfo	
	//variable/g subsets=numpnts (breaks1)-1
	
	killwaves/z w0,w1,w2,w3,breaks,breaks1, breaks
	TextBox/C/N=text0/A=RT name
	DoWindow/T SNS_LR_Graph,name
	ControlBar /T 32
	string tracename=StringFromList(0, TraceNameList("SNS_LR_Graph", ";", 1 ),";")
	Cursor/P A, $tracename,0
end

Function  SNSLR_SetVariableControl(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName
	Variable varNum
	String varStr
	String varName
	String Thenote
	variable oldqshift,oldshift
	
	 
	 
	 IF(cmpstr(ctrlName,"qshiftdelta")==0)
	 	NVAR qshiftdelta=root:Packages:SNSLRTool:qshiftdelta
	 	NVAR qshift=root:Packages:SNSLRTool:qshift
	 	SetVariable qshift, limits={0,100,qshiftdelta},value= root:Packages:SNSLRTool:qshift
	 endif
	
	IF(cmpstr(ctrlName,"shift")==0)
		string DF,rWavename=CsrWave(A), qwavename,swavename,kwavename,wwavename
		DF=getdatafolder(1)
		setdatafolder getwavesDataFolder(csrwaveref(A),1) 	
		qwavename="q"+rwavename[1,100];swavename="s"+rwavename[1,100]
		wave swave=$swavename,rwave=$rwavename
		
		TheNote=note(rwave )
		OldShift= NumberByKey("shift" ,TheNote,"=",";")	
		If (Oldshift==NaN)
			Doalert 0, "shift=1; missing in rwave note"
		endif
		rwave=rwave*varNum/OldShift
		swave=swave*varNum/OldShift
		TheNote= ReplaceNumberByKey("shift" ,TheNote,varnum,"=",";")	
		Note/K rwave, TheNote	
		setdatafolder DF
	endif
	
	IF(cmpstr(ctrlName,"qshift")==0)
		rWavename=CsrWave(A)
		DF=getdatafolder(1)
		string qqwavename
		setdatafolder getwavesDataFolder(csrwaveref(A),1) 	
		kwavename="k"+rwavename[1,100];qqwavename="q"+rwavename[1,100]
		wave qwave=$kwavename//wont shift concatonated data.
		wave qqwave=$qqwavename
		
		If (waveexists(qwave))//forpartial waves folder
			string TheNoteq=note(qwave )
			variable OldQShiftq= NumberByKey("Qshift" ,TheNoteq,"=",";")
			If (OldQshiftq==NaN)
				Doalert 0, "qshift=1; missing in rwave note"	
			endif
			qwave=qwave*varNum/OldQshiftq
			TheNoteq= ReplaceNumberByKey("Qshift" ,TheNoteq,varnum,"=",";")		
			Note/K qwave, TheNoteq
		endif
		
		If (waveexists(qqwave))//for qrs folder
			string TheNoteqq=note(qqwave )
			variable OldQShiftqq= NumberByKey("Qshift" ,TheNoteqq,"=",";")
			If (OldQshiftqq==NaN)
				Doalert 0, "qqshift=1; missing in rwave note"
			endif
			qqwave=qqwave*varNum/OldQshiftqq
			TheNoteqq= ReplaceNumberByKey("Qshift" ,TheNoteqq,varnum,"=",";")	
			Note/K qqwave, TheNoteqq
		endif	
		setdatafolder DF
	endif
end


function DeletePointsButton()//works on top graph, mut be pointing to correct folder???
	// ControlBar /T 20
	 Button Deletepoint,pos={0,0},size={100,16} ,font="Times New Roman",fSize=10,proc= SNSLR_InputPanelButtonProc,title="delete point"
End

Function ConcatQRSwaves()
	string wavename1,wavename2
	variable passes=0
	SVAR basename
	NVAR subsets
	RemoveFromGraph/Z $"r"+basename
	killwaves/Z $"q"+basename,$"r"+basename,$"s"+basename
	
	do
		wavename1="q"+basename			
		wavename2=":PartialWavesFolder:k"+basename+num2str(passes)
		If (passes==0)
			Concatenate/o {$wavename2},$wavename1
		else
			Concatenate {$wavename2},$wavename1
		endif
					
		wavename1="r"+basename
		wavename2=":PartialWavesFolder:r"+basename+num2str(passes)
		If (passes==0)
			Concatenate/o {$wavename2},$wavename1
		else
			Concatenate {$wavename2},$wavename1
		endif
						
		wavename1="s"+basename
		wavename2=":PartialWavesFolder:s"+basename+num2str(passes)
		If (passes==0)
			Concatenate/o {$wavename2},$wavename1
		else
			Concatenate {$wavename2},$wavename1
		endif
		
				wavename1="w"+basename
		wavename2=":PartialWavesFolder:w"+basename+num2str(passes)
		If (passes==0)
			Concatenate/o {$wavename2},$wavename1
		else
			Concatenate {$wavename2},$wavename1
		endif

			
		passes+=1
	while (passes<subsets)
	Sort $"q"+basename,  $"r"+basename ,$"q"+basename, $"S"+basename,$"w"+basename

end

function SNSLR_InputPanelButtonProc(ctrlName) : ButtonControl
	string ctrlName
	String 	DF,rwavename, qwavename,swavename,kwavename,Wwavename
	NVAR passnumber=root:Packages:SNSLRTool:pass
	
	if(cmpstr(ctrlName,"concat")==0)
		SVAR basename
		NVAR subsets		
		ConcatQRSwaves()
		APPENDtograph $"r"+basename vs$"q"+basename		
	endif	
	
	IF(cmpstr(ctrlName,"restorepartialwave")==0)
		 rWavename=CsrWave(A)
		 	If (stringmatch (rwavename,""))
			doalert 0, "Put cursor on a wave"
			abort
		endif
		string destinationfolder= getwavesDataFolder(csrwaveref(A),1) 
	qwavename="q"+rwavename[1,100];swavename="s"+rwavename[1,100];kwavename="k"+rwavename[1,100]
		
		string sourcename=":OriginalWavesFolder:"+kwavename
		string destination=":PartialWavesFolder:"+kwavename
		duplicate/o $sourcename,$destination
		
		sourcename=":OriginalWavesFolder:"+rwavename
		destination=":PartialWavesFolder:"+rwavename
		duplicate/o $sourcename,$destination
		
		sourcename=":OriginalWavesFolder:"+swavename
		destination=":PartialWavesFolder:"+swavename
		duplicate/o $sourcename,$destination
		NVAR qshift=root:Packages:SNSLRTool:qshift,shift=root:Packages:SNSLRTool:shift
		qshift=1;shift=1
	endif	
	
	
	IF(cmpstr(ctrlName,"RemoveReflTrace")==0)
			ClearGraph_LR()
		endif
	
	if(cmpstr(ctrlName,"Deletepoint")==0)
		DF=getdatafolder(1)		
		setdatafolder getwavesDataFolder(csrwaveref(A),1) 	
		Removepnt("SNS_LR_Graph")
		setdatafolder DF
	endif
	
	if(cmpstr(ctrlName,"PlotSNSLR")==0)
		SNS_LR_RegeneratorPLOT()
		NVAR qshift=root:Packages:SNSLRTool:qshift,shift=root:Packages:SNSLRTool:shift
		qshift=1;shift=1
	endif
	
	if(cmpstr(ctrlName,"FullQ4R")==0)
		FullRq4plot()
	endif
	
		if(cmpstr(ctrlName,"Q4R")==0)
		Rq4plot()
	endif
end

function FullRq4plot()
		ClearGraph_LR()
		string rwavename,qwavename
		SVAR DFolder=root:Packages:SNSLRTool:DataFolderName
		IF (stringmatch (Dfolder,"*SNS_LR_Graph:"))
			doalert 0, "Pick a folder"
			abort	
		endif
		setdatafolder  DFolder
		SVAR basename
		rwavename= "r"+basename
		qwavename="q"+basename
		Duplicate/o $qwavename, rq4temp
		wave rwave=$rwavename
		rq4temp=rwave*rq4temp^4
		appendtograph rq4temp vs $qwavename
		ModifyGraph log(left)=1,mode=3,marker=19,msize=1
		Label left "R x q4";Label bottom "q(\\S-1\\M)"
end



Function ClearGraph_LR()
	string tracename, tracelist=TraceNameList("SNS_LR_Graph", ";", 1 )
		variable i, imax
		imax=ItemsInList(tracelist  ,";")
				If (imax>9)
					imax =9
				endif
			for (i=imax;i>=1;i-=1)
					tracename=StringFromList(i, tracelist,";")		
					RemoveFromGraph $tracename	;AbortOnRTE
			endfor	
			TextBox/K/N=text0
	end

Function Removepnt(windowname)// qrs  only   use "" window name for top  deletepoint delete point
	string windowname
	string DF,rWavename=CsrWave(A,windowname), qwavename,swavename,wwavename,fwavename
	DF=getdatafolder(1)
	variable CurrentPoint=pcsr(A,windowname)
	setdatafolder getwavesDataFolder(csrwaveref(A),1) 	
	qwavename="q"+rwavename[1,100];swavename="s"+rwavename[1,100];wwavename="w"+rwavename[1,100],fwavename="f"+rwavename[1,100]
	wave swave=$swavename,qwave=$qwavename,rwave=$rwavename,wwave=$wwavename,fwave=$fwavename
	rWave[CurrentPoint]=NaN  //must be pointing to data folder with wave
	variable i=0, imax=numpnts(rwave)  
	for (i=imax;i>=0;i-=1)//zap nans
		if (numtype(rwave[i])==2)
			Deletepoints i, 1, rwave,qwave
			If (WaveExists(Wwave ))
				Deletepoints i, 1,wwave
			endif
			If (WaveExists(fwave))
				Deletepoints i, 1,fwave
			endif		
			If (WaveExists(swave))
				Deletepoints i, 1,swave
			endif		
		endif	
	endfor
	setdatafolder DF
end


function ChangetoLineandPoints(modetype,qcolors)
	variable qcolors,modetype
	Prompt modetype, "Type of display", popup,"Lines;Sticks;Dots;Markers;Lines &Markers"
	Prompt qcolors,"Mixed Colors?",popup,"Colors;Grays;No"
	
	Silent 1;pauseupdate
	string markertypes="19;17;16;23;18;8;5;6;22;7;0;1;2;25;26;28;29;15;14;4;3;17;16;23;18;8;5;6;22;7;0;1;2;25;26;28;29;15;14;4;3"
	string rcolortypes="65535;0;0;65535;52428;0;39321;52428;1;26214;65535;0;0;65535;52428;0;39321;52428;1;26214"
	string gcolortypes="0;0;65535;43690;1;0;13101;52425;24548;26214;65535;0;0;65535;52428;0;39321;52428;1;26214"
	string bcolortypes="0;65535;0;0;41942;0;1;1;52428;26214;65535;0;0;65535;52428;0;39321;52428;1;26214"
	string ListofWaves=TraceNameList("",";",1),wavename
	variable position1=strsearch(ListofWaves,";",0),position2=position1
	variable markpos1=strsearch(markertypes,";",0), markpos2=markpos1
	wavename=ListofWaves[0,(position1-1)]
	variable marktp=str2num(markertypes[0,(markpos1-1)])
	variable red=FindString2num(0,rcolortypes,";")
	variable green=FindString2num(0,gcolortypes,";")
	variable blue=FindString2num(0,bcolortypes,";")
	variable grey=0
	if(qcolors!=3)
		if(qcolors==1)
			ModifyGraph mode=modetype,marker($wavename)=marktp,rgb($wavename)=(red,green,blue)
		else
			ModifyGraph mode=modetype,marker($wavename)=marktp,rgb($wavename)=(grey,grey,grey)
		endif
	else
		ModifyGraph mode=modetype,marker($wavename)=marktp
	endif
	//
	variable length=strlen(ListofWaves)
	variable counter=1
	do
		position1=position2
		markpos1=markpos2
		position2=strsearch(ListofWaves,";",(position1+1))
		if(position2==-1)
			break
		endif
		markpos2=strsearch(markertypes,";",(markpos1+1))
		marktp=str2num(markertypes[(markpos1+1),(markpos2-1)])
		if(counter<=17)
			red=FindString2num(counter,rcolortypes,";")
			green=FindString2num(counter,gcolortypes,";")
			blue=FindString2num(counter,bcolortypes,";")
		else
			red=(counter-17)*1000
			green=(counter-17)*1000
			blue=(counter-17)*1000
		endif
		grey=counter*10000
		wavename=ListofWaves[(position1+1),(position2-1)]
		if(qcolors!=3)
			if(qcolors==1)
				ModifyGraph mode=modetype,marker($wavename)=marktp,rgb($wavename)=(red,green,blue)
			else
				ModifyGraph mode=modetype,marker($wavename)=marktp,rgb($wavename)=(grey,grey,grey)
			endif
		else
			ModifyGraph mode=modetype,marker($wavename)=marktp
		endif
		counter+=1
	while(position2!=(length-1))
EndMacro

Function FindString2num(index,strings,separator)
	variable index//starts at 0
	string strings,separator
	
	variable pos1=0,pos2=0
	string answer
	variable counter=0
	do
		pos2=strsearch(strings,";",pos1)
		answer=strings[pos1,(pos2-1)]
		pos1=pos2+1
		counter+=1
	while(counter<(index+1))
	return(str2num(answer))
end